/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.myangel.playerlocatorplus.PlayerLocatorPlus;
import com.myangel.playerlocatorplus.config.ClientValues;
import com.myangel.playerlocatorplus.config.ColorMode;
import com.myangel.playerlocatorplus.config.ServerValues;
import com.myangel.playerlocatorplus.server.ServerTracker;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public final class PlayerLocatorConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private PlayerLocatorConfig() {
    }

    public static void register(IEventBus modBus) {
        modBus.addListener(PlayerLocatorConfig::onConfigLoad);
        modBus.addListener(PlayerLocatorConfig::onConfigReload);
    }

    private static void onConfigLoad(ModConfigEvent.Loading event) {
        PlayerLocatorConfig.apply(event.getConfig());
    }

    private static void onConfigReload(ModConfigEvent.Reloading event) {
        PlayerLocatorConfig.apply(event.getConfig());
    }

    private static void apply(ModConfig config) {
        if (config.getSpec() == SERVER_SPEC) {
            SERVER.bake(config.getConfigData());
        } else if (config.getSpec() == CLIENT_SPEC) {
            CLIENT.bake(config.getConfigData());
        }
    }

    public static ServerValues getServerValues() {
        return SERVER.getValues();
    }

    public static ClientValues getClientValues() {
        return CLIENT.getValues();
    }

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static final class Server {
        private final ForgeConfigSpec.BooleanValue enabled;
        private final ForgeConfigSpec.BooleanValue sendServerConfig;
        private final ForgeConfigSpec.BooleanValue sendDistance;
        private final ForgeConfigSpec.IntValue maxDistance;
        private final ForgeConfigSpec.DoubleValue directionPrecision;
        private final ForgeConfigSpec.IntValue ticksBetweenUpdates;
        private final ForgeConfigSpec.BooleanValue sneakingHides;
        private final ForgeConfigSpec.BooleanValue pumpkinHides;
        private final ForgeConfigSpec.BooleanValue mobHeadsHide;
        private final ForgeConfigSpec.BooleanValue invisibilityHides;
        private final ForgeConfigSpec.EnumValue<ColorMode> colorMode;
        private final ForgeConfigSpec.IntValue constantColor;
        private final ForgeConfigSpec.BooleanValue overrideVisible;
        private final ForgeConfigSpec.BooleanValue overrideVisibleEmpty;
        private final ForgeConfigSpec.BooleanValue overrideFadeMarkers;
        private final ForgeConfigSpec.DoubleValue overrideFadeStart;
        private final ForgeConfigSpec.DoubleValue overrideFadeEnd;
        private final ForgeConfigSpec.DoubleValue overrideFadeEndOpacity;
        private final ForgeConfigSpec.BooleanValue overrideShowHeight;
        private final ForgeConfigSpec.BooleanValue overrideAlwaysShowHeads;
        private final ForgeConfigSpec.BooleanValue overrideShowHeadsOnTab;
        private final ForgeConfigSpec.BooleanValue overrideShowNamesOnTab;
        private volatile ServerValues values = ServerValues.defaults();

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server-side configuration for Player Locator Plus").push("server");
            this.enabled = builder.comment("Is the mod enabled server-side?").define("enabled", true);
            this.sendServerConfig = builder.comment("Send the server config to clients that opt in?").define("sendServerConfig", true);
            this.sendDistance = builder.comment("Send distance information together with direction?").define("sendDistance", true);
            this.maxDistance = builder.comment("Maximum distance at which markers are visible (0 = unlimited).").defineInRange("maxDistance", 0, 0, 1000000);
            this.directionPrecision = builder.comment("Precision factor for far-away players. Higher = smoother but easier to triangulate.").defineInRange("directionPrecision", 300.0, 2.0, 2048.0);
            this.ticksBetweenUpdates = builder.comment("Ticks between network updates. Lower = more frequent updates.").defineInRange("ticksBetweenUpdates", 5, 0, 200);
            this.sneakingHides = builder.comment("Should sneaking hide players from the locator?").define("sneakingHides", true);
            this.pumpkinHides = builder.comment("Should wearing a carved pumpkin hide players?").define("pumpkinHides", true);
            this.mobHeadsHide = builder.comment("Should wearing a mob/player head hide players?").define("mobHeadsHide", true);
            this.invisibilityHides = builder.comment("Should invisibility hide players?").define("invisibilityHides", true);
            this.colorMode = builder.comment("How to determine marker colors.").defineEnum("colorMode", (Enum)ColorMode.UUID);
            this.constantColor = builder.comment("Hex color (0xRRGGBB) used when color mode is CONSTANT.").defineInRange("constantColor", 0xFFFFFF, 0, 0xFFFFFF);
            builder.comment("Client style overrides applied when sendServerConfig is enabled.").push("clientOverrides");
            this.overrideVisible = builder.define("visible", true);
            this.overrideVisibleEmpty = builder.define("visibleEmpty", false);
            this.overrideFadeMarkers = builder.define("fadeMarkers", true);
            this.overrideFadeStart = builder.defineInRange("fadeStart", 100.0, 0.0, 1000000.0);
            this.overrideFadeEnd = builder.defineInRange("fadeEnd", 1000.0, 0.0, 1000000.0);
            this.overrideFadeEndOpacity = builder.defineInRange("fadeEndOpacity", 0.3, 0.0, 1.0);
            this.overrideShowHeight = builder.define("showHeight", true);
            this.overrideAlwaysShowHeads = builder.define("alwaysShowHeads", false);
            this.overrideShowHeadsOnTab = builder.define("showHeadsOnTab", true);
            this.overrideShowNamesOnTab = builder.define("showNamesOnTab", true);
            builder.pop();
            builder.pop();
        }

        private void bake(CommentedConfig configData) {
            ClientValues overrideValues = new ClientValues((Boolean)this.overrideVisible.get(), (Boolean)this.overrideVisibleEmpty.get(), true, (Boolean)this.overrideFadeMarkers.get(), (Double)this.overrideFadeStart.get(), (Double)this.overrideFadeEnd.get(), (Double)this.overrideFadeEndOpacity.get(), (Boolean)this.overrideShowHeight.get(), (Boolean)this.overrideAlwaysShowHeads.get(), (Boolean)this.overrideShowHeadsOnTab.get(), (Boolean)this.overrideShowNamesOnTab.get());
            this.values = new ServerValues((Boolean)this.enabled.get(), (Boolean)this.sendServerConfig.get(), (Boolean)this.sendDistance.get(), (Integer)this.maxDistance.get(), (Double)this.directionPrecision.get(), (Integer)this.ticksBetweenUpdates.get(), (Boolean)this.sneakingHides.get(), (Boolean)this.pumpkinHides.get(), (Boolean)this.mobHeadsHide.get(), (Boolean)this.invisibilityHides.get(), (ColorMode)((Object)this.colorMode.get()), (Integer)this.constantColor.get(), overrideValues);
            ServerTracker.markConfigDirty();
            PlayerLocatorPlus.LOGGER.debug("Baked server config: {}", (Object)this.values);
        }

        public ServerValues getValues() {
            return this.values;
        }
    }

    public static final class Client {
        private final ForgeConfigSpec.BooleanValue visible;
        private final ForgeConfigSpec.BooleanValue visibleEmpty;
        private final ForgeConfigSpec.BooleanValue acceptServerConfig;
        private final ForgeConfigSpec.BooleanValue fadeMarkers;
        private final ForgeConfigSpec.DoubleValue fadeStart;
        private final ForgeConfigSpec.DoubleValue fadeEnd;
        private final ForgeConfigSpec.DoubleValue fadeEndOpacity;
        private final ForgeConfigSpec.BooleanValue showHeight;
        private final ForgeConfigSpec.BooleanValue alwaysShowHeads;
        private final ForgeConfigSpec.BooleanValue showHeadsOnTab;
        private final ForgeConfigSpec.BooleanValue showNamesOnTab;
        private volatile ClientValues values = ClientValues.defaults();

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-side configuration for Player Locator Plus").push("client");
            this.visible = builder.comment("Show the player locator overlay?").define("visible", true);
            this.visibleEmpty = builder.comment("Show the locator even when no markers are present?").define("visibleEmpty", false);
            this.acceptServerConfig = builder.comment("Allow the server to override client settings?").define("acceptServerConfig", true);
            this.fadeMarkers = builder.comment("Fade markers of far away players?").define("fadeMarkers", true);
            this.fadeStart = builder.comment("Distance at which markers start fading.").defineInRange("fadeStart", 100.0, 0.0, 1000000.0);
            this.fadeEnd = builder.comment("Distance at which markers reach final opacity.").defineInRange("fadeEnd", 1000.0, 0.0, 1000000.0);
            this.fadeEndOpacity = builder.comment("Opacity at fade end (0-1).").defineInRange("fadeEndOpacity", 0.3, 0.0, 1.0);
            this.showHeight = builder.comment("Show arrows indicating large height differences?").define("showHeight", true);
            this.alwaysShowHeads = builder.comment("Always show player heads on markers? (overrides TAB behaviour)").define("alwaysShowHeads", false);
            this.showHeadsOnTab = builder.comment("Show player heads when the Tab list key is pressed?").define("showHeadsOnTab", true);
            this.showNamesOnTab = builder.comment("Show player name plaques when the Tab list key is pressed?").define("showNamesOnTab", true);
            builder.pop();
        }

        private void bake(CommentedConfig configData) {
            this.values = new ClientValues((Boolean)this.visible.get(), (Boolean)this.visibleEmpty.get(), (Boolean)this.acceptServerConfig.get(), (Boolean)this.fadeMarkers.get(), (Double)this.fadeStart.get(), (Double)this.fadeEnd.get(), (Double)this.fadeEndOpacity.get(), (Boolean)this.showHeight.get(), (Boolean)this.alwaysShowHeads.get(), (Boolean)this.showHeadsOnTab.get(), (Boolean)this.showNamesOnTab.get());
            PlayerLocatorPlus.LOGGER.debug("Baked client config: {}", (Object)this.values);
        }

        public ClientValues getValues() {
            return this.values;
        }
    }
}

