/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.myangel.playerlocatorplus.config.ColorMode;
import com.myangel.playerlocatorplus.config.PlayerLocatorConfig;
import com.myangel.playerlocatorplus.server.ServerTracker;
import com.myangel.playerlocatorplus.util.PlayerDataState;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;

public final class PLPCommand {
    private static final SimpleCommandExceptionType INVALID_COLOR = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.color.invalid"));

    private PLPCommand() {
    }

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"plp").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(source -> source.m_6761_(2))).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerTracker.markConfigDirty();
            ServerTracker.fullResend(source.m_81377_());
            source.m_288197_(() -> Component.m_237113_((String)"Player Locator config reloaded"), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"random").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerTracker.sendFakePlayers(player);
            return 1;
        }))).then(Commands.m_82127_((String)"color").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).map(formatting -> formatting.m_126666_().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder)).executes(ctx -> PLPCommand.changeColor((CommandContext<CommandSourceStack>)ctx, true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(ctx -> PLPCommand.changeColor((CommandContext<CommandSourceStack>)ctx, false))))));
    }

    private static int changeColor(CommandContext<CommandSourceStack> ctx, boolean self) throws CommandSyntaxException {
        if (PlayerLocatorConfig.getServerValues().colorMode() != ColorMode.CUSTOM) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.player-locator-plus.color.wrong-color-mode"));
            return 0;
        }
        ServerPlayer target = self ? ((CommandSourceStack)ctx.getSource()).m_81375_() : EntityArgument.m_91474_(ctx, (String)"player");
        String colorInput = StringArgumentType.getString(ctx, (String)"color");
        int color = PLPCommand.parseColor(colorInput);
        PlayerDataState state = PlayerDataState.get(((CommandSourceStack)ctx.getSource()).m_81377_());
        state.setCustomColor(target.m_20148_(), color);
        if (self) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.player-locator-plus.color.self", (Object[])new Object[]{PLPCommand.formatColor(color)}), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.player-locator-plus.color.other", (Object[])new Object[]{target.m_7755_(), PLPCommand.formatColor(color)}), false);
        }
        return 1;
    }

    private static int parseColor(String input) throws CommandSyntaxException {
        String value = input.trim();
        if (value.startsWith("#")) {
            value = value.substring(1);
        }
        if (value.length() == 6 && value.chars().allMatch(ch -> Character.digit(ch, 16) != -1)) {
            return Integer.parseInt(value, 16);
        }
        ChatFormatting formatting = ChatFormatting.m_126657_((String)value);
        if (formatting != null && formatting.m_126665_() != null) {
            return formatting.m_126665_();
        }
        throw INVALID_COLOR.create();
    }

    private static Component formatColor(int color) {
        String hex = String.format(Locale.ROOT, "#%06X", color & 0xFFFFFF);
        return Component.m_237113_((String)hex).m_130938_(style -> style.m_178520_(color & 0xFFFFFF));
    }
}

