/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.client;

public final class Animatable {
    private float naturalFreq = 120.0f;
    private float targetValue;
    private float currentValue;
    private float lastDisplacement;
    private float lastVelocity;

    public Animatable(float initialValue) {
        this.targetValue = initialValue;
        this.currentValue = initialValue;
        this.lastDisplacement = initialValue;
    }

    public void setNaturalFreq(float naturalFreq) {
        this.naturalFreq = naturalFreq;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void setTargetValue(float targetValue) {
        this.targetValue = targetValue;
    }

    public void updateValues(float timeElapsedMs) {
        float adjustedDisplacement = this.lastDisplacement - this.targetValue;
        double deltaT = (double)timeElapsedMs / 1000.0;
        double coeffA = adjustedDisplacement;
        double coeffB = this.lastVelocity + this.naturalFreq * adjustedDisplacement;
        double nFdT = (double)(-this.naturalFreq) * deltaT;
        double displacement = (coeffA + coeffB * deltaT) * Math.exp(nFdT);
        double currentVelocity = (coeffA + coeffB * deltaT) * Math.exp(nFdT) * (double)(-this.naturalFreq) + coeffB * Math.exp(nFdT);
        float newValue = (float)(displacement + (double)this.targetValue);
        float newVelocity = (float)currentVelocity;
        this.lastDisplacement = newValue;
        this.lastVelocity = newVelocity;
        this.currentValue = newValue;
    }

    public float getTargetValue() {
        return this.targetValue;
    }
}

