/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.xkmc.golemdungeons.content.config.SpawnConfig;
import dev.xkmc.golemdungeons.content.config.TrialConfig;
import dev.xkmc.golemdungeons.init.GolemDungeons;
import dev.xkmc.golemdungeons.init.data.GDConfig;
import dev.xkmc.golemdungeons.init.data.spawn.IllagerGolemSpawn;
import dev.xkmc.golemdungeons.util.GolemUtils;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Raid.class})
public abstract class RaidMixin {
    @Unique
    private final List<AbstractGolemEntity<?, ?>> golemdungeons$golemRaiders = new LinkedList();
    @Shadow
    private int f_37681_;
    @Shadow
    @Final
    private ServerLevel f_37675_;
    @Shadow
    private float f_37678_;

    @Shadow
    public abstract void m_37713_(int var1, Raider var2, @Nullable BlockPos var3, boolean var4);

    @Shadow
    @Nullable
    public abstract Raider m_37750_(int var1);

    @Shadow
    public abstract boolean m_37762_();

    @Shadow
    public abstract BlockPos m_37780_();

    @Inject(method={"spawnGroup"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;updateBossbar()V")})
    private void golemdungeons$raidGolems(BlockPos pos, CallbackInfo ci) {
        if (!((Boolean)GDConfig.COMMON.enableRaidGolems.get()).booleanValue()) {
            return;
        }
        int wave = this.f_37681_;
        TrialConfig data = (TrialConfig)GolemDungeons.TRIAL.getEntry(IllagerGolemSpawn.RAIDS);
        if (data == null) {
            return;
        }
        if (wave >= data.list.size()) {
            wave = data.list.size() - 1;
        }
        if (wave < 0) {
            return;
        }
        ArrayList<TrialConfig.WaveEntry> list = data.list.get(wave);
        Raider leader = this.m_37750_(wave);
        for (TrialConfig.WaveEntry ent : list) {
            LivingEntity le;
            SpawnConfig e = (SpawnConfig)GolemDungeons.SPAWN.getEntry(ent.target());
            if (e == null || (le = e.summon(this.f_37675_)) == null) continue;
            if (le instanceof Raider) {
                Raider raider = (Raider)le;
                this.m_37713_(wave, raider, pos, false);
            } else {
                le.m_146884_(Vec3.m_82539_((Vec3i)pos));
                GolemUtils.recursiveAdd(this.f_37675_, (Entity)le);
            }
            if (leader == null) continue;
            if (!(le instanceof AbstractGolemEntity)) {
                le = le.m_6688_();
            }
            if (!(le instanceof AbstractGolemEntity)) continue;
            AbstractGolemEntity golem = (AbstractGolemEntity)le;
            golem.setLeader((LivingEntity)leader);
            this.f_37678_ += golem.m_21233_();
            this.golemdungeons$golemRaiders.add(golem);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void golemdungeons$tickRaidGolem(CallbackInfo ci) {
        if (this.m_37762_() || this.golemdungeons$golemRaiders.isEmpty()) {
            return;
        }
        this.golemdungeons$golemRaiders.removeIf(e -> !e.m_6084_() || e.m_9236_() != this.f_37675_ || this.m_37780_().m_123331_((Vec3i)e.m_20183_()) > 12544.0);
        Raider leader = this.m_37750_(this.f_37681_);
        if (leader == null || !leader.m_6084_() || leader.f_19797_ % 10 != 0) {
            return;
        }
        for (AbstractGolemEntity<?, ?> e2 : this.golemdungeons$golemRaiders) {
            LivingEntity old = e2.getLeader();
            if (leader == old) continue;
            e2.setLeader((LivingEntity)leader);
        }
    }

    @ModifyReturnValue(method={"getHealthOfLivingRaiders"}, at={@At(value="RETURN")})
    private float golemdungeons$addGolemHealth(float original) {
        for (AbstractGolemEntity<?, ?> e : this.golemdungeons$golemRaiders) {
            original += e.m_21223_();
        }
        return original;
    }

    @ModifyReturnValue(method={"getTotalRaidersAlive"}, at={@At(value="RETURN")})
    private int golemdungeons$addGolem(int original) {
        return original + this.golemdungeons$golemRaiders.size();
    }
}

