/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.init.data;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.xkmc.golemdungeons.compat.cataclysm.data.CataclysmCompatData;
import dev.xkmc.golemdungeons.compat.twilightforest.data.TwilightCompatData;
import dev.xkmc.golemdungeons.init.data.spawn.FactoryGolemSpawn;
import dev.xkmc.golemdungeons.init.data.spawn.IllagerGolemSpawn;
import dev.xkmc.golemdungeons.init.data.spawn.PiglinGolemSpawn;
import dev.xkmc.golemdungeons.init.data.spawn.SculkGolemSpawn;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public enum GDLang {
    FLAME_SWORD_ATK("tooltip.flame_sword_atk", "Deal %s extra fire damage when attacking, bypassing target armor", 1, ChatFormatting.GRAY),
    FLAME_SWORD_LOOT("tooltip.flame_sword_loot", "Drop more golem materials when metal golems slay other golems with this sword", 0, ChatFormatting.GRAY),
    SCULK_SCYTHE_ATK("tooltip.sculk_scythe_atk", "On hit, create sonic burst dealing sonic damage at %s of attack damage", 1, ChatFormatting.GRAY),
    ANCIENT_FORGE_ATK("tooltip.ancient_forge_atk", "Melee damage bypass armor", 0, ChatFormatting.GRAY),
    TRIAL_MEDAL("tooltip.trial_medal.spawner", "Right click golem spawner to charge them immediately", 0, ChatFormatting.GRAY),
    TRIAL_MEDAL_CATA("tooltip.trial_medal.cata", "Right click Cataclysm boss spawner to summon boss with golem reinforcement", 0, ChatFormatting.GRAY),
    OFFERING_CATA("tooltip.offering.cata", "Offer to [%s] to summon %s with golem reinforcement", 2, ChatFormatting.GRAY),
    CHARGE_TIME("tooltip.charge_time", "Charging: %s", 1, ChatFormatting.GRAY),
    WAND_USAGE("tooltip.wand.usage", "Scroll to select Faction", 0, ChatFormatting.GRAY),
    WAND_MODID("tooltip.wand.modid", "Faction Category: %s", 1, ChatFormatting.GRAY),
    WAND_FACTION("tooltip.wand.faction", "Selected: %s", 1, ChatFormatting.GRAY),
    WAND_BLOCK("tooltip.wand.block", "Right click ground to summon a random golem in the facton.", 0, ChatFormatting.GRAY),
    WAND_TRIAL("tooltip.wand.trial", "Right click Golem Spawner to set trial to spawn.", 0, ChatFormatting.GRAY),
    LOCATE_ABANDONED("tooltip.locate_abandoned", "Locates the Abandoned Golem Factory", 0, ChatFormatting.GRAY),
    LOCATE_CRIMSON("tooltip.locate_crimson", "Locates the Piglin Golem Factory in Crimson Forest", 0, ChatFormatting.GRAY),
    LOCATE_SCULK("tooltip.locate_sculk", "Locates the Sculk Infested Golem Factory in Deep Dark", 0, ChatFormatting.GRAY),
    BAR_WAVE("bar.wave", " - Wave %s: ", 1, null),
    BAR_VICTORY("bar.victory", "Victory", 0, null),
    BAR_CHARGING("bar.charging", "Charging", 0, null),
    BAR_SUMMONING("bar.summoning", "Summoning", 0, null),
    BAR_PROGRESS("bar.progress", "%s Remaining", 1, null);

    private final String key;
    private final String def;
    private final int arg;
    private final ChatFormatting format;

    private GDLang(String key, @Nullable String def, int arg, ChatFormatting format) {
        this.key = "modulargolems." + key;
        this.def = def;
        this.arg = arg;
        this.format = format;
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static MutableComponent getTranslate(String s) {
        return Component.m_237115_((String)("modulargolems." + s));
    }

    public static MutableComponent fromTrial(ResourceLocation id) {
        return Component.m_237115_((String)Util.m_137492_((String)"trial", (ResourceLocation)id));
    }

    public MutableComponent get(Object ... args) {
        if (args.length != this.arg) {
            throw new IllegalArgumentException("for " + this.name() + ": expect " + this.arg + " parameters, got " + args.length);
        }
        MutableComponent ans = Component.m_237110_((String)this.key, (Object[])args);
        if (this.format != null) {
            return ans.m_130940_(this.format);
        }
        return ans;
    }

    public static void genLang(RegistrateLangProvider pvd) {
        for (GDLang lang : GDLang.values()) {
            pvd.add(lang.key, lang.def);
        }
        pvd.add(Util.m_137492_((String)"trial", (ResourceLocation)FactoryGolemSpawn.FACTORY_ALL), "Factory Remnant");
        pvd.add(Util.m_137492_((String)"trial", (ResourceLocation)PiglinGolemSpawn.PIGLIN_ALL), "Piglin Legacy");
        pvd.add(Util.m_137492_((String)"trial", (ResourceLocation)SculkGolemSpawn.SCULK_ALL), "Sculk Infestation");
        pvd.add(Util.m_137492_((String)"trial", (ResourceLocation)IllagerGolemSpawn.ILLAGER_ALL), "Illagers' Creations");
        pvd.add("trial_selector.golemdungeons", "Golem Dungeons");
        if (ModList.get().isLoaded("cataclysm")) {
            CataclysmCompatData.genLang(pvd);
        }
        if (ModList.get().isLoaded("twilightforest")) {
            TwilightCompatData.genLang(pvd);
        }
    }
}

